unit uCallDisplay;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ToolWin, StdCtrls, ExtCtrls, ActnList, ImgList,  tapi, hbTapi;

type
  TFrameCallDisplay = class(TFrame)
    Panel_Background: TPanel;
    ActionList1: TActionList;
    Action_HoldCall: TAction;
    Action_AnswerCall: TAction;
    Action_CancelCall: TAction;
    ToolBar5: TToolBar;
    Button2: TToolButton;
    Button3: TToolButton;
    Button1: TToolButton;
    ToolButton6: TToolButton;
    Action_Dial: TAction;
    ToolButton7: TToolButton;
    Action_SwapHold: TAction;
    Label_Number: TLabel;
    Label_Address: TLabel;
    Label_Name: TLabel;
    Label_State: TLabel;
    Label_Mode: TLabel;
    Label_Detail2: TLabel;
    procedure DoHold(Sender: TObject);
    procedure DoAnswer(Sender: TObject);
    procedure DoDrop(Sender: TObject);
    procedure DoDial(Sender: TObject);
    procedure DoSwapHold(Sender: TObject);
  private
    FCall        : TTapiCall;
    procedure SetLabel(ALabel: TLabel; Value: String; Inverted: Boolean=FALSE);
  public
    procedure UpdateActionList;
    procedure UpdateView;
    procedure Init;
    property  Call         : TTapiCall read FCall write FCall;
  end;

implementation

uses uMain;

{$R *.DFM}

procedure TFrameCallDisplay.Init;
var i: integer;
begin
  Call := nil;
  for i := 0 to Panel_Background.ControlCount-1 do
    if Panel_Background.Controls[i] Is TLabel then
      TLabel(Panel_Background.Controls[i]).Caption := '';
  UpdateView;
  UpdateActionList;
end;

procedure TFrameCallDisplay.UpdateActionList;
begin
  Action_Dial.Enabled               := (Call <> nil) and (Call.Features and LINECALLFEATURE_DIAL > 0);//Call.Active;
  Action_CancelCall.Enabled         := (Call <> nil) and (Call.Features and LINECALLFEATURE_DROP > 0);//Call.Active;
  Action_AnswerCall.Enabled         := (Call <> nil) and (Call.Features and LINECALLFEATURE_ANSWER > 0);// Call.IsOffering;
  Action_HoldCall.Enabled           := (Call <> nil) and (Call.Features and LINECALLFEATURE_HOLD > 0);// and Call.IsConnected;
  Action_SwapHold.Enabled           := (Call <> nil) and (Call.Features and LINECALLFEATURE_SWAPHOLD > 0);
end;

procedure TFrameCallDisplay.UpdateView;
begin
  if Call = nil then
    exit;

  Label_Address.Caption := Call.Address.AddressName;

  if Call.IsIncoming then
  begin
    SetLabel(Label_Number,  Call.CallerID.Address, FALSE);
    SetLabel(Label_Name,    Call.CallerID.Name,    FALSE);
  end
{$IFDEF VER_PROF}
  else if Call.IsOutgoing then
  begin
    SetLabel(Label_Number,  Call.CalledID.Address, FALSE);
    SetLabel(Label_Name,    Call.CalledID.Name,    FALSE);
  end
{$ENDIF}
  else
  begin
    SetLabel(Label_Number, '', FALSE);
    SetLabel(Label_Name,   '',    FALSE);
  end;

  SetLabel(Label_State, Call.StateText, TRUE);

  if Call.State = LINECALLSTATE_DISCONNECTED then
  begin
    SetLabel(Label_Mode, Call.StateModeText, FALSE);
  end
  else if Call.Info.MediaMode <> LINEMEDIAMODE_INTERACTIVEVOICE then
  begin
    SetLabel(Label_Mode, Call.MediaModeText, FALSE);
  end
  else
  begin
    SetLabel(Label_Mode, '', FALSE);
  end;

  SetLabel(Label_Detail2, '', FALSE)
end;

procedure TFrameCallDisplay.SetLabel(ALabel: TLabel; Value: String; Inverted: Boolean);
begin
  ALabel.Caption := Value;

  if Inverted then
  begin
    if Value <> '' then
    begin
      ALabel.Font.Color := clWhite;
      ALabel.Color      := clGray;
    end
    else
    begin
      ALabel.Font.Color := clGray;
      ALabel.Color      := clWhite;
    end;
  end;
end;


procedure TFrameCallDisplay.DoAnswer(Sender: TObject);
begin
  if Call <> nil then
  begin
    try
      Call.Owner := TRUE;
      Call.Answer;
      MainForm.LogFmt('Answer started (RequestID=x%x)',[Call.Line.LastRequestID]);
    except
    on E:Exception do
      MainForm.LogFmt('Answer failed! %s', [E.Message]);
    end;
  end;
end;

procedure TFrameCallDisplay.DoDrop(Sender: TObject);
begin
  try
    Call.Owner := TRUE;
    Call.Drop;
    MainForm.LogFmt('Drop started (RequestID=x%x)',[Call.Line.LastRequestID]);
  except
    on E:Exception do
      MainForm.LogFmt('Drop failed! %s', [E.Message]);
  end;
end;

procedure TFrameCallDisplay.DoDial(Sender: TObject);
var s: string;
begin
  if Call <> nil then
  begin
    s := '';
    if InputQuery('Dial','Telephone number', s) then
    begin
      try
        Call.Dial(s);
        MainForm.LogFmt('Dial started (RequestID= %d)',[Call.Line.LastRequestID]);
      except
        on E:Exception do
          MainForm.LogFmt('Dial failed! %s', [E.Message]);
      end;
    end;
  end
end;

procedure TFrameCallDisplay.DoHold(Sender: TObject);
begin
{$IFDEF VER_PROF}
  if (Call <> nil) and Call.Owner then
  begin
    try
      if (Call.State and LINECALLSTATE_ONHOLD) > 0 then
        Call.UnHold
      else
        Call.Hold;
    except
    end;
  end;
{$ELSE}
  MessageDlg('Hold and Unhold are features of the Proffessional Edition', mtInformation, [mbOK], 0);
{$ENDIF}
end;

procedure TFrameCallDisplay.DoSwapHold(Sender: TObject);
{$IFDEF VER_PROF}
var c: TTapiCall; i: integer;
{$ENDIF}
begin
{$IFDEF VER_PROF}
  c := nil;
  i := 0;
  while (c = nil) and (i < Call.Line.Calls.Count) and (c <> call) do
  begin
    if Call.Line.Calls[i].IsHeld then
      c := Call.Line.Calls[i];
    inc(i);
  end;
  if c = nil then exit;
  try
    Call.SwapHold(c);
    MainForm.LogFmt('SwapHold started (LastRequestID=x%x)',[Call.Line.LastRequestID]);
  except
    on E:Exception do
      MainForm.LogFmt('SwapHold failed! %s', [E.Message]);
  end;
{$ELSE}
  MessageDlg('Hold and Unhold are features of the Proffessional Edition', mtInformation, [mbOK], 0);
{$ENDIF}
end;


end.
